
#include <stdlib.h>

/* Define the vector type */
typedef struct {
	int dim; // dimension of the vector
	float *elements; // pointer to elements
} Vector;

/* Define the matrix type */
typedef struct {
	int rows; // number of rows
	int cols; // number of columns
	float **elements; // pointer to rows of elements
} Matrix;

/* Defined in matrix-ops.c */
int multiply_matrix();
void set_to_identity();
void swap_column();
void copy_matrix();
void add_row(float *, float *, float, int);
int find_nonzero_column();
int find_nonzero_row();
int is_zero(float);

/* Defined in matrix-io.c */
Matrix read_matrix();
void output_matrix();
Matrix allocate_matrix();
void free_matrix();

/* Defined in matrix-det.c */
float compute_det_permutation();
float determinant();

/* Defined in matrix-inv.c */
float LUP_decompose();
float inv_lower();
float inv_upper();
void inv_permutation();
float inv_matrix();
