
#include <stdio.h>
#include "matrix.h"


int main()
{
	Matrix A;
	Matrix invA;
	float det;
	int n;

	A = read_matrix();

	if (A.rows != A.cols) {
		printf("Cannot compute inverse: input is not a square matrix\n");
		free_matrix(A);
		return 0;
	}

	invA = allocate_matrix(A.rows, A.cols);

	det = inv_matrix(A, invA);
	if (is_zero(det))
		printf("Matrix not invertible\n");
	else {
		printf("Determinant = %5.2f\n", det);
		output_matrix("Inverse of A =\n", invA);
	}
	free_matrix(A);
	free_matrix(invA);
}
			
